#include "chunked_stream.h"

namespace NNetmon {
    TAtomic MemPoolStatsFixedBlockCount;

    template <size_t S>
    inline TSafeFixedSizeAllocator* GetFixedSizeAllocator() noexcept {
        static TSafeFixedSizeAllocator Allocator_(S, S);
        return &Allocator_;
    }

    TSafeFixedSizeAllocator* GetBlockAllocator(size_t capacity) {
        switch (capacity) {
            case 64UL: {
                return GetFixedSizeAllocator<64UL>();
            }
            case 128UL: {
                return GetFixedSizeAllocator<128UL>();
            }
            case 256UL: {
                return GetFixedSizeAllocator<256UL>();
            }
            case 512UL: {
                return GetFixedSizeAllocator<512UL>();
            }
            case 1024UL: {
                return GetFixedSizeAllocator<1024UL>();
            }
            case 2048UL: {
                return GetFixedSizeAllocator<2048UL>();
            }
            case 4096UL: {
                return GetFixedSizeAllocator<4096UL>();
            }
            case 8192UL: {
                return GetFixedSizeAllocator<8192UL>();
            }
            case 16384UL: {
                return GetFixedSizeAllocator<16384UL>();
            }
            case 32768UL: {
                return GetFixedSizeAllocator<32768UL>();
            }
            case 65536UL: {
                return GetFixedSizeAllocator<65536UL>();
            }
            case 131072UL: {
                return GetFixedSizeAllocator<131072UL>();
            }
            case 262144UL: {
                return GetFixedSizeAllocator<262144UL>();
            }
            default: {
                ythrow yexception() << "no block of such size available";
            }
        }
    }
}
