#include <infra/netmon/statistics/histograms.h>

#include <cmath>

extern "C" int LLVMFuzzerTestOneInput(const uint8_t *data, size_t size) {
    using namespace NNetmon;

    const double* start(reinterpret_cast<const double*>(data));
    const double* end(start + size / (sizeof(double) / sizeof(uint8_t)));

    TSampleHistogram first;
    TSampleHistogram second;
    for (const auto* it(start); it != end; ++it) {
        first.Append(std::fabs(*it));
        second.Append(*it);
    }

    TSampleHistogram source;
    source.Merge(first, 16);
    source.Merge(second, 32);

    flatbuffers::FlatBufferBuilder builder;
    builder.Finish(source.ToProto(builder));

    const NCommon::TSampleHistogram& dumped(*flatbuffers::GetRoot<NCommon::TSampleHistogram>(builder.GetBufferPointer()));
    TSampleHistogram target(dumped);
    if (source != target) {
        __builtin_trap();
    }

    return 0;
}
