#include "varint.h"

#include <library/cpp/testing/unittest/registar.h>

#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

using namespace NNetmon;

class TVarintTest: public TTestBase {
    UNIT_TEST_SUITE(TVarintTest);
    UNIT_TEST(TestInteger)
    UNIT_TEST(TestDouble)
    UNIT_TEST_SUITE_END();

private:
    inline void TestInteger() {
        TBuffer buf;
        TBufferStream stream(buf);

        VarintEncode<ui32>(stream, 0, 0);
        VarintEncode<ui32>(stream, 1, 0);
        VarintEncode<ui32>(stream, 0, 1);
        VarintEncode<ui32>(stream, 1, 1);
        VarintEncode<ui32>(stream, 1 << 8, 1 << 20);
        VarintEncode<ui32>(stream, std::numeric_limits<ui8>::max(), std::numeric_limits<ui16>::max());
        VarintEncode<ui32>(stream, std::numeric_limits<ui32>::max(), std::numeric_limits<ui32>::max());
        VarintEncode<ui32>(stream, 2);
        stream.Finish();

        UNIT_ASSERT(buf.Size());

        AssertEqual<ui32>(stream, 0, 0);
        AssertEqual<ui32>(stream, 1, 0);
        AssertEqual<ui32>(stream, 0, 1);
        AssertEqual<ui32>(stream, 1, 1);
        AssertEqual<ui32>(stream, 1 << 8, 1 << 20);
        AssertEqual<ui32>(stream, std::numeric_limits<ui8>::max(), std::numeric_limits<ui16>::max());
        AssertEqual<ui32>(stream, std::numeric_limits<ui32>::max(), std::numeric_limits<ui32>::max());
        AssertEqual<ui32>(stream, 2);

        ui32 x, y;
        UNIT_ASSERT(VarintDecode<ui32>(stream, x, y) == EVarintStatus::END_OF_STREAM);
    }

    inline void TestDouble() {
        TBuffer buf;
        TBufferStream stream(buf);

        VarintEncode<double>(stream, 0.0, 0.0);
        VarintEncode<double>(stream, 1.0, 2.0);
        VarintEncode<double>(stream, 3.0, 4.0);
        VarintEncode<double>(stream, 5.0);
        stream.Finish();

        AssertEqual<double>(stream, 0.0, 0.0);
        AssertEqual<double>(stream, 1.0, 2.0);
        AssertEqual<double>(stream, 3.0, 4.0);
        AssertEqual<double>(stream, 5.0);

        double x, y;
        UNIT_ASSERT(VarintDecode<double>(stream, x, y) == EVarintStatus::END_OF_STREAM);
    };

    template <class T>
    inline void AssertEqual(TBufferStream& stream, T first, T second) {
        T x, y;
        UNIT_ASSERT(VarintDecode<T>(stream, x, y) == EVarintStatus::TWO_VALUES);
        UNIT_ASSERT_EQUAL(x, first);
        UNIT_ASSERT_EQUAL(y, second);
    }

    template <class T>
    inline void AssertEqual(TBufferStream& stream, T first) {
        T x, y;
        UNIT_ASSERT(VarintDecode<T>(stream, x, y) == EVarintStatus::ONE_VALUE);
        UNIT_ASSERT_EQUAL(x, first);
    }
};

UNIT_TEST_SUITE_REGISTRATION(TVarintTest);
