#pragma once

#include <infra/netmon/tasks/storage.h>
#include <infra/netmon/library/boxes.h>

#include <infra/netmon/agent/idl/tasks.pb.h>

namespace NNetmon {
    class TEnqueuedTask : public IAgentTask {
    public:
        TEnqueuedTask(const NClient::TEnqueuedTask& task);

        const TKey& Key() const noexcept override;
        TInstant Deadline() const noexcept override;

        // used to dump data into zookeeper
        void Dump(IOutputStream& stream) const noexcept override;

    private:
        IAgentTask::TKey Key_;
        NClient::TEnqueuedTask Task_;
    };

    class TEnqueuedTaskIndex : public IAgentTaskWatcher {
    public:
        TEnqueuedTaskIndex();
        ~TEnqueuedTaskIndex();

        void Load(const IAgentTask::TKey& key, IInputStream& stream) noexcept override;
        void Delete(const IAgentTask::TKey& key) noexcept override;

        TVector<NClient::TEnqueuedTask> FindByHost(const TString& hostname) const noexcept;

    private:
        class TImpl;
        TLazyLockedBox<TImpl> Impl;
    };
}
