#include <infra/netmon/tasks/enqueued_task_index.h>
#include <infra/netmon/library/api_client_helpers.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

using namespace NNetmon;

class TEnqueuedTaskIndexTest: public TTestBase {
    UNIT_TEST_SUITE(TEnqueuedTaskIndexTest);
    UNIT_TEST(TestFindHost)
    UNIT_TEST_SUITE_END();

private:
    inline void TestFindHost() {
        IAgentTask::TKey firstKey, secondKey, thirdKey, fourthKey;

        CreateGuid(&firstKey);
        CreateGuid(&secondKey);
        CreateGuid(&thirdKey);
        CreateGuid(&fourthKey);

        NClient::TEnqueuedTask firstTask, secondTask, thirdTask, fourthTask;

        firstTask.SetKey(GetGuidAsString(firstKey));
        firstTask.SetHost("a");
        secondTask.SetKey(GetGuidAsString(secondKey));
        secondTask.SetHost("b");
        thirdTask.SetKey(GetGuidAsString(thirdKey));
        thirdTask.SetHost("b");
        fourthTask.SetKey(GetGuidAsString(fourthKey));
        fourthTask.SetHost("c");

        Load(firstKey, firstTask);
        Load(secondKey, secondTask);
        Load(thirdKey, thirdTask);
        Load(fourthKey, fourthTask);

        UNIT_ASSERT(Index.FindByHost("x").empty());

        auto result(Index.FindByHost("b"));
        UNIT_ASSERT_EQUAL(result.size(), 2);
        UNIT_ASSERT_EQUAL(result[0].GetKey(), GetGuidAsString(secondKey));
        UNIT_ASSERT_EQUAL(result[1].GetKey(), GetGuidAsString(thirdKey));

        Index.Delete(firstKey);
        Index.Delete(secondKey);
        Index.Delete(thirdKey);
        Index.Delete(fourthKey);

        UNIT_ASSERT(Index.FindByHost("b").empty());
    }

    inline void Load(const IAgentTask::TKey& key, const NClient::TEnqueuedTask& obj) {
        TBufferStream stream;
        ::Save(&stream, obj);
        Index.Load(key, stream);
    }

    TEnqueuedTaskIndex Index;
};

UNIT_TEST_SUITE_REGISTRATION(TEnqueuedTaskIndexTest);
