#pragma once

#include <infra/netmon/tasks/storage.h>
#include <infra/netmon/library/boxes.h>

#include <infra/netmon/agent/idl/tasks.pb.h>

namespace NNetmon {
    class TFinishedTask : public IAgentTask {
    public:
        TFinishedTask(const NClient::TTaskResult& result);

        TKey ParentKey() const noexcept;

        const TKey& Key() const noexcept override;
        TInstant Deadline() const noexcept override;

        // used to dump data into zookeeper
        void Dump(IOutputStream& stream) const noexcept override;

    private:
        IAgentTask::TKey Key_;
        NClient::TTaskResult Result_;
    };

    class TFinishedTaskIndex : public IAgentTaskWatcher {
    public:
        TFinishedTaskIndex();
        ~TFinishedTaskIndex();

        void Load(const IAgentTask::TKey& key, IInputStream& stream) noexcept override;
        void Delete(const IAgentTask::TKey& key) noexcept override;

        bool FindByParentKey(const IAgentTask::TKey& key, NClient::TTaskResult& result) const noexcept;
        TMaybe<IAgentTask::TKey> KeyByParentKey(const IAgentTask::TKey& key) const noexcept;

        THashMap<TString, int> VersionHistogram() const noexcept;
        TString GetVersion(const TString& hostname) const noexcept;
        TVector<TString> FindByVersion(const TString& version) const noexcept;

        void ForEachVersion(std::function<void(const NClient::TVersionResult&, TInstant)> func) const;

    private:
        class TImpl;
        TLazyLockedBox<TImpl> Impl;
    };
}
