#pragma once

#include <infra/netmon/host_storage.h>
#include <infra/netmon/library/scheduler.h>

namespace NNetmon {
    class TTerminatedHostsUpdater: public TNonCopyable {
    public:
        TTerminatedHostsUpdater();
        ~TTerminatedHostsUpdater();

        void AddHost(const TTopology::THostRef host);
        void RemoveHost(const TTopology::THostRef host);

        THostStorage::TState::TConstValueRef GetState() const;

    private:
        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };

    class TTerminatedHostsMaintainer: public IHostsMaintainer, public TNonCopyable {
    public:
        TTerminatedHostsMaintainer(const TTopologyStorage& topologyStorage);
        ~TTerminatedHostsMaintainer();

        void UpdateHosts(const flatbuffers::Vector<const NCommon::THost*>& hosts);

        TTopologyStorage::THostSetBox::TConstValueRef GetHosts() const override;

    private:
        class TImpl;
        THolder<TImpl> Impl;
    };
}
