#pragma once

#include <infra/netmon/library/boxes.h>
#include <infra/netmon/library/scheduler.h>

namespace NNetmon {
    class TStaffStorage: public TNonCopyable {
    public:
        TStaffStorage();
        ~TStaffStorage();

        TVector<TString> ExpandGroup(const TString& groupName) const noexcept;
        TSet<TString> ExpandLoginsAndGroups(const TVector<TString>& groupsAndLogins) const noexcept;
        TSet<TString> ExpandLoginsAndGroups(const TSet<TString>& groupsAndLogins) const noexcept;

        TThreadPool::TFuture SpinAndWait() noexcept;

    private:
        TStaffStorage(bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
