#include <infra/netmon/topology/clients/staff.h>
#include <infra/netmon/topology/settings.h>
#include <infra/netmon/library/api_handler_helpers.h>

#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

using namespace NNetmon;

namespace {
    struct TStaffContext : public TNonCopyable {
    };

    class TStaffReply: public THttpReply<THttpDispatcher, TStaffContext> {
    public:
        TStaffReply(TStaffContext& serverContext, const TServiceRequest::TRef clientContext)
            : THttpReply<THttpDispatcher, TStaffContext>(serverContext, clientContext)
        {
        }

        void Process() {
            Response
                .BeginObject()
                    .WriteKey("result")
                    .BeginList();
            if (FirstPage) {
                Response
                    .BeginObject()
                        .WriteKey("id")
                        .WriteInt(1)
                        .WriteKey("login")
                        .WriteString("first")
                        .WriteKey("groups")
                        .BeginList()
                        .EndList()
                        .WriteKey("department_group")
                        .BeginObject()
                            .WriteKey("ancestors")
                            .BeginList()
                            .EndList()
                            .WriteKey("url")
                            .WriteString("some_group")
                        .EndObject()
                    .EndObject();
            }
            Response
                .EndList()
                .EndObject();
        }

        void PreprocessRequest(THttpInput&) {
        }

        void ParseRequest(THttpInput& input) {
            auto parsedRequest = TParsedHttpFull(input.FirstLine());
            TCgiParameters params(parsedRequest.Cgi);
            FirstPage = !params.Has("_query");
        }

        void WriteResponse(THttpOutput& output) {
            output << THttpResponse()
                .SetContentType(TStringBuf("application/json"))
                .SetContent(Response.Str());
            output.Finish();
        }

    private:
        NJsonWriter::TBuf Response;
        bool FirstPage;
    };
}

class TStaffTest: public TTestBase {
    UNIT_TEST_SUITE(TStaffTest);
    UNIT_TEST(TestExpand)
    UNIT_TEST_SUITE_END();

private:
    inline void TestExpand() {
        TPortManager portManager;
        ui16 port(portManager.GetPort(12345));

        TStaffContext context;
        THttpHandler<TStaffReply> service(context);

        TString host("localhost");
        TWebServer server(THttpServerOptions().SetHost(host).SetPort(port).SetThreads(1));
        server.Add("/v3/persons", service);
        TWebServer::TThreadGuard serverGuard(server);

        TTopologySettings::Get()->SetStaffUrl(TStringBuilder() << "http://" << host << ":" << port);

        TStaffStorage staff;
        staff.SpinAndWait().Wait();

        UNIT_ASSERT_EQUAL(staff.ExpandGroup("some_group"), TVector<TString>{"first"});
    }
};

UNIT_TEST_SUITE_REGISTRATION(TStaffTest);
