#pragma once

#include <infra/netmon/host_storage.h>
#include <infra/netmon/library/event_hub.h>
#include <infra/netmon/library/scheduler.h>

#include <util/generic/maybe.h>

namespace NNetmon {
    class TWalleUpdater: public IHostsMaintainer, public TNonCopyable {
    public:
        TWalleUpdater(const TTopologyStorage& topologyStorage,
                      const TDuration& timeOffset);
        ~TWalleUpdater();

        struct THostCounter {
            using TRef = TAtomicSharedPtr<THostCounter>;
            using TConstRef = TAtomicSharedPtr<const THostCounter>;

            std::size_t Total = 0;
            THashMap<TTopology::TDatacenterRef, std::size_t> ByDc;
            THashMap<TTopology::TLineRef, std::size_t> ByQueue;
        };

        TTopologyStorage::THostSetBox::TConstValueRef GetHosts() const override {
            return GetDeadHosts();
        }

        TTopologyStorage::THostSetBox::TConstValueRef GetDeadHosts() const;
        void ReplaceDeadHosts(const TTopologyStorage::THostSet& hosts);
        THostCounter::TConstRef GetHostCountUnderMaintenance(TExpressionId expressionId) const;

        bool IsReady() const;
        const TVoidEventHub& OnUpdated() const;

        TThreadPool::TFuture SpinAndWait() noexcept;

        static constexpr ui64 RequestPageSize = 10000;

    private:
        TWalleUpdater(const TTopologyStorage& topologyStorage,
                      const TDuration& timeOffset,
                      bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
