#pragma once

#include <infra/netmon/topology/topology_storage.h>

using namespace NNetmon;

class TGlobalTopology {
    Y_DECLARE_SINGLETON_FRIEND()
public:
    static TExpressionStorage& GetExpressionStorage() {
        return Get().ExpressionStorage;
    }

    static TGroupStorage& GetGroupStorage() {
        return Get().GroupStorage;
    }

    static TTopologyStorage& GetTopologyStorage() {
        return Get().TopologyStorage;
    }

    TGlobalTopology()
        : TopologyUpdater(false)
        , ExpressionStorage(false)
        , GroupStorage(false)
        , TopologyStorage(TopologyUpdater, ExpressionStorage, GroupStorage, false)
    {
    }

private:
    static TGlobalTopology& Get() {
        return *HugeSingletonWithPriority<TGlobalTopology, 100003>();
    }

    TTopologyUpdater TopologyUpdater;
    TExpressionStorage ExpressionStorage;
    TGroupStorage GroupStorage;
    TTopologyStorage TopologyStorage;
};
