#pragma once

#include <infra/netmon/topology/types.h>
#include <infra/netmon/library/scheduler.h>
#include <infra/netmon/library/event_hub.h>

#include <infra/netmon/expression/parser.h>

#include <library/cpp/threading/future/future.h>

#include <util/generic/set.h>

namespace NNetmon {
    class TExpressionStorage : public TNonCopyable {
    public:
        struct TResult {
            TString Id;
            TString Expression;
            TExpressionId ExpressionId;
            TSet<TString> Owners;
        };

        struct TChangeSet {
            TMaybe<TString> Id;
            TMaybe<TString> Expression;
            TMaybe<TSet<TString>> Owners;
        };

        TExpressionStorage(bool schedule=true);
        ~TExpressionStorage();

        TVector<TExpressionDnf> GetExpressionDnfs() const;
        TMaybe<TExpressionDnf> GetExpressionDnf(TExpressionId expressionId) const;
        const TVoidEventHub& OnChanged() const;

        TVector<TResult> List() const;
        TMaybe<TResult> Get(const TString& id) const;
        TVector<TResult> Find(TExpressionId expressionId) const;

        [[nodiscard]] NThreading::TFuture<TResult> Upsert(const TString& id, const TChangeSet& changeSet) const;
        [[nodiscard]] NThreading::TFuture<void> Delete(const TString& id) const;

        bool IsReady() const;

    private:
        class TImpl;
        TIntrusivePtr<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
