#include <infra/netmon/library/metrics.h>

#include <util/generic/singleton.h>
#include <util/generic/xrange.h>

#include <cmath>

namespace NNetmon {
    namespace {
        struct TYasmBuckets {
            TYasmBuckets() {
                Values.emplace_back(0.0);
                // 8us .. 38 days
                for (i64 idx : xrange(-12, 37)) {
                    Values.emplace_back(std::pow(1.5, idx));
                }
            }

            TVector<double> Values;
        };
    }

    const TVector<double>& GetYasmBuckets() {
        return Singleton<TYasmBuckets>()->Values;
    }
}
