#pragma once

#include <library/cpp/unistat/unistat.h>
#include <library/cpp/unistat/raii.h>

namespace NNetmon {
    const TVector<double>& GetYasmBuckets();

    enum class ETopologySignals {
        TopologyParsingTime,
        TopologyIndexGenerationTime,
        TopologyReloadTime,
        TopologyCleanupTime,
        TopologyHostsCount,

        WalleBlockedHostNamesFetchTime,
        WalleHostsFetchTime
    };

    inline TString ToString(ETopologySignals v) {
        switch (v) {
            case ETopologySignals::TopologyParsingTime:
                return "topology_parsing_time";
            case ETopologySignals::TopologyIndexGenerationTime:
                return "topology_index_generation_time";
            case ETopologySignals::TopologyReloadTime:
                return "topology_reload_time";
            case ETopologySignals::TopologyCleanupTime:
                return "topology_cleanup_time";
            case ETopologySignals::TopologyHostsCount:
                return "topology_hosts_count";

            case ETopologySignals::WalleBlockedHostNamesFetchTime:
                return "walle_blocked_host_names_fetch_time";
            case ETopologySignals::WalleHostsFetchTime:
                return "walle_hosts_fetch_time";
        };
    }

    class TTopologyStatsInitializer {
    public:
        void Init(TUnistat& t) const {
            const auto& intervals = GetYasmBuckets();

            t.DrillHistogramHole("topology_parsing_time", "hgram", NUnistat::TPriority(10), intervals);
            t.DrillHistogramHole("topology_index_generation_time", "hgram", NUnistat::TPriority(10), intervals);
            t.DrillHistogramHole("topology_reload_time", "hgram", NUnistat::TPriority(10), intervals);
            t.DrillHistogramHole("topology_cleanup_time", "hgram", NUnistat::TPriority(10), intervals);

            t.DrillFloatHole("topology_hosts_count", "axxx", NUnistat::TPriority(10), NUnistat::TStartValue(0), EAggregationType::LastValue);

            t.DrillHistogramHole( "walle_blocked_host_names_fetch_time", "hgram", NUnistat::TPriority(10), intervals);
            t.DrillHistogramHole( "walle_hosts_fetch_time", "hgram", NUnistat::TPriority(10), intervals);
        }
    };
}
