#pragma once

#include <infra/netmon/library/boxes.h>
#include <infra/netmon/library/scheduler.h>
#include <infra/netmon/library/event_hub.h>

#include <infra/netmon/idl/topology.fbs.h>
#include <infra/netmon/agent/idl/common.pb.h>

namespace NNetmon {
    class TTopologyUpdater : public TNonCopyable {
    public:
        struct TInfo {
            using TBox = TAtomicLockedBox<TInfo>;

            TInfo() = default;
            TInfo(const TString& skynetId,
                  const TString& plainMDSLink,
                  const TString& secureMDSLink);
            TInfo(const TInfo& info);
            TInfo(const NTopology::TInfo& info);

            flatbuffers::Offset<NTopology::TInfo> ToProto(flatbuffers::FlatBufferBuilder& builder) const;
            void ToProto(NClient::TTopologyInfo& info) const;

            const TString SkynetId;
            const TString PlainMDSLink;
            const TString SecureMDSLink;
        };

        TTopologyUpdater(bool schedule=true);
        ~TTopologyUpdater();

        TInfo::TBox::TConstValueRef GetInfo() const;
        const TVoidEventHub& OnChanged() const;

        class IImpl;
    private:
        TIntrusivePtr<IImpl> MakeImpl();

        TIntrusivePtr<IImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
