#include <infra/netmon/topology/topology_updater.h>
#include <infra/netmon/library/api_client_helpers.h>

#include <library/cpp/testing/unittest/registar.h>

using namespace NNetmon;

class TTopologyUpdaterTest: public TTestBase {
    UNIT_TEST_SUITE(TTopologyUpdaterTest);
    UNIT_TEST(TestSerialization)
    UNIT_TEST(TestEmpty)
    UNIT_TEST_SUITE_END();

private:
    using TInfo = TTopologyUpdater::TInfo;

    inline void TestSerialization() {
        TInfo source("1", "2", "3");

        TString buf;
        flatbuffers::FlatBufferBuilder builder;
        builder.Finish(source.ToProto(builder));
        WriteFlatBuffer(buf, builder);

        TFlatObject<NTopology::TInfo> obj;
        ReadFlatBuffer(buf, obj);
        UNIT_ASSERT(obj.Verify());

        TInfo dest(*obj);
        UNIT_ASSERT_EQUAL(source.SkynetId, dest.SkynetId);
        UNIT_ASSERT_EQUAL(source.PlainMDSLink, dest.PlainMDSLink);
        UNIT_ASSERT_EQUAL(source.SecureMDSLink, dest.SecureMDSLink);
    }

    inline void TestEmpty() {
        TInfo info;
        UNIT_ASSERT(info.SkynetId.empty());
        UNIT_ASSERT(info.PlainMDSLink.empty());
        UNIT_ASSERT(info.SecureMDSLink.empty());
    }
};

UNIT_TEST_SUITE_REGISTRATION(TTopologyUpdaterTest);
