#include <infra/netmon/topology/types.h>

#include <util/stream/output.h>
#include <util/string/ascii.h>

template <>
void Out<NNetmon::ENetworkType>(
        IOutputStream& stream,
        TTypeTraits<NNetmon::ENetworkType>::TFuncParam network) {
    switch (network) {
        case NNetmon::BACKBONE4:
            stream << TStringBuf("bb4");
            return;
        case NNetmon::BACKBONE6:
            stream << TStringBuf("bb6");
            return;
        case NNetmon::FASTBONE6:
            stream << TStringBuf("fb6");
            return;
        case NNetmon::FASTBONE_CS1:
            stream << TStringBuf("fb-cs1");
            return;
        case NNetmon::FASTBONE_CS2:
            stream << TStringBuf("fb-cs2");
            return;
        case NNetmon::BACKBONE_CS3:
            stream << TStringBuf("bb-cs3");
            return;
        case NNetmon::BACKBONE_CS4:
            stream << TStringBuf("bb-cs4");
            return;
        case NNetmon::SPARSE_BACKBONE6:
            stream << TStringBuf("mtn-bb6");
            return;
        case NNetmon::SPARSE_FASTBONE6:
            stream << TStringBuf("mtn-fb6");
            return;
        default:
            stream << TStringBuf("null");
            return;
    }
}

template <>
void Out<NNetmon::ETrafficClassType>(
        IOutputStream& stream,
        TTypeTraits<NNetmon::ETrafficClassType>::TFuncParam trafficClass) {
    switch (trafficClass) {
        case NNetmon::CS0:
            stream << TStringBuf("CS0");
            return;
        case NNetmon::CS1:
            stream << TStringBuf("CS1");
            return;
        case NNetmon::CS2:
            stream << TStringBuf("CS2");
            return;
        case NNetmon::CS3:
            stream << TStringBuf("CS3");
            return;
        case NNetmon::CS4:
            stream << TStringBuf("CS4");
            return;
        default:
            stream << TStringBuf("null");
            return;
    }
}

template <>
bool TryFromString<NNetmon::ETrafficClassType>(const TString& s, NNetmon::ETrafficClassType& result) {
    if (AsciiEqualsIgnoreCase(s, TStringBuf("CS0"))) {
        result = NNetmon::CS0;
    } else if (AsciiEqualsIgnoreCase(s, TStringBuf("CS1"))) {
        result = NNetmon::CS1;
    } else if (AsciiEqualsIgnoreCase(s, TStringBuf("CS2"))) {
        result = NNetmon::CS2;
    } else if (AsciiEqualsIgnoreCase(s, TStringBuf("CS3"))) {
        result = NNetmon::CS3;
    } else if (AsciiEqualsIgnoreCase(s, TStringBuf("CS4"))) {
        result = NNetmon::CS4;
    } else {
        return false;
    }
    return true;
}

template <>
void Out<NNetmon::EProtocolType>(
        IOutputStream& stream,
        TTypeTraits<NNetmon::EProtocolType>::TFuncParam protocol) {
    switch (protocol) {
        case NNetmon::ICMP:
            stream << TStringBuf("icmp");
            return;
        case NNetmon::UDP:
            stream << TStringBuf("udp");
            return;
        case NNetmon::TCP:
            stream << TStringBuf("tcp");
            return;
        case NNetmon::LINK_POLLER:
            stream << TStringBuf("link_poller");
            return;
        default:
            stream << TStringBuf("null");
            return;
    }
}

template <>
bool TryFromString<NNetmon::EProtocolType>(const TString& s, NNetmon::EProtocolType& result) {
    if (AsciiEqualsIgnoreCase(s, TStringBuf("icmp"))) {
        result = NNetmon::ICMP;
    } else if (AsciiEqualsIgnoreCase(s, TStringBuf("udp"))) {
        result = NNetmon::UDP;
    } else if (AsciiEqualsIgnoreCase(s, TStringBuf("tcp"))) {
        result = NNetmon::TCP;
    } else {
        return false;
    }
    return true;
}
