#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/strbuf.h>
#include <util/string/cast.h>

namespace NNetmon {
    enum ENetworkType {
        NIL_NETWORK,
        BACKBONE4,
        BACKBONE6,
        FASTBONE6,
        FASTBONE_CS1,
        FASTBONE_CS2,
        BACKBONE_CS3,
        BACKBONE_CS4,
        SPARSE_BACKBONE6,
        SPARSE_FASTBONE6
    };

    enum ETrafficClassType {
        NIL_CLASS,
        CS0,
        CS1,
        CS2,
        CS3,
        CS4
    };

    enum EProtocolType {
        NIL_PROTOCOL,
        ICMP,
        UDP,
        TCP,
        LINK_POLLER
    };

    enum EVlans {
        MTN_BACKBONE = 688,
        MTN_FASTBONE = 788
    };

    using TExpressionId = std::size_t;
    using TExpressionIdList = TVector<TExpressionId>;

    inline TStringBuf NetworkToString(ui64 network) noexcept {
        switch (network) {
            case BACKBONE4:
                return TStringBuf("bb4");
            case BACKBONE6:
                return TStringBuf("bb6");
            case FASTBONE6:
                return TStringBuf("fb6");
            case FASTBONE_CS1:
                return TStringBuf("fb-cs1");
            case FASTBONE_CS2:
                return TStringBuf("fb-cs2");
            case BACKBONE_CS3:
                return TStringBuf("bb-cs3");
            case BACKBONE_CS4:
                return TStringBuf("bb-cs4");
            case SPARSE_BACKBONE6:
                return TStringBuf("mtn-bb6");
            case SPARSE_FASTBONE6:
                return TStringBuf("mtn-fb6");
            default:
                return TStringBuf("null");
        }
    }

    inline TStringBuf TrafficClassToString(ui64 trafficClass) noexcept {
        switch (trafficClass) {
            case CS0:
                return TStringBuf("CS0");
            case CS1:
                return TStringBuf("CS1");
            case CS2:
                return TStringBuf("CS2");
            case CS3:
                return TStringBuf("CS3");
            case CS4:
                return TStringBuf("CS4");
            default:
                return TStringBuf("null");
        }
    }

    inline TStringBuf ProtocolToString(ui64 protocol) noexcept {
        switch (protocol) {
            case ICMP:
                return TStringBuf("icmp");
            case UDP:
                return TStringBuf("udp");
            case TCP:
                return TStringBuf("tcp");
            case LINK_POLLER:
                return TStringBuf("link_poller");
            default:
                return TStringBuf("null");
        }
    }
}

template <>
bool TryFromString<NNetmon::ETrafficClassType>(const TString& s, NNetmon::ETrafficClassType& result);

template <>
bool TryFromString<NNetmon::EProtocolType>(const TString& s, NNetmon::EProtocolType& result);
