#pragma once

#include <infra/netmon/library/scheduler.h>

#include <library/cpp/json/writer/json_value.h>

namespace NNetmon {
    class TUserDataStorage: public TNonCopyable {
    public:
        TUserDataStorage();
        ~TUserDataStorage();

        NJson::TJsonValue GetExpressionData(const TString& id, const TVector<TString>& fields = {}) const;
        NThreading::TFuture<void> UpsertExpressionData(const TString& id, const NJson::TJsonValue& data) const;
        NThreading::TFuture<void> DeleteExpressionDataFields(const TString& id, const TVector<TString>& fields) const;
        NThreading::TFuture<void> DeleteExpressionData(const TString& id) const;
        NThreading::TFuture<void> MoveExpressionData(const TString& id, const TString& newId) const;

        bool IsQualitySignalsEnabled(const TString& id) const;

    private:
        TUserDataStorage(bool schedule);

        class TImpl;
        THolder<TImpl> Impl;

        TScheduledTask::TTaskGuard SchedulerGuard;
    };
}
