import argparse
import os
import requests
import zlib

from google.protobuf.json_format import MessageToJson

from infra.netmon.agent.idl import api_pb2 as api
from infra.netmon.agent.idl import common_pb2 as common

# NETMON_URL = 'https://netmon.yandex-team.ru'
NETMON_URL = 'http://yp-netmon-aggregator-noc-sla-sas-1.sas.yp-c.yandex.net'
# NETMON_URL = 'http://localhost:14242'

NETMON_URL = os.environ.get('NETMON_URL', NETMON_URL)


def make_request(url, request, response):
    headers = {
        'Content-Type': 'application/x-coded-protobuf',
        'Content-Encoding': 'gzip'
    }
    r = requests.post(NETMON_URL + '/api/client/v1/{}'.format(url), headers=headers, data=zlib.compress(request.SerializeToString()))
    response.ParseFromString(r.content)
    print(MessageToJson(response))


def expand_group(group):
    request = api.TExpandGroupRequest(Expression=group)
    response = api.TExpandGroupResponse()
    make_request('expand_groups', request, response)


def scheduled_probes(host):
    request = api.TScheduledProbesRequest(Type=1, Host=host, NotConsiderHostInNextSchedule=True)
    response = api.TScheduledProbesResponse()
    make_request('scheduled_probes', request, response)


def terminated_host(host):
    request = api.TTerminatedHostRequest(Host=host)
    response = api.TTerminatedHostResponse()
    make_request('terminated_host', request, response)


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('command', choices=['scheduled_probes', 'terminated_host'])
    parser.add_argument('--hostname', help='hostname')
    args = parser.parse_args()

    if args.command == 'scheduled_probes':
        scheduled_probes(args.hostname)
    elif args.command == 'terminated_host':
        terminated_host(args.hostname)

    # expand_group('G@RTC_EXPERIMENTAL')

if __name__ == '__main__':
    main()
