#include <infra/netmon/library/clickhouse/translate.h>
#include <infra/netmon/probe_storage.h>
#include <infra/netmon/topology/common_ut.h>

#include <library/cpp/clickhouse/client/client.h>

#include <util/string/subst.h>
#include <util/string/split.h>
#include <util/stream/file.h>

using namespace NNetmon;

// SourceFqdn, TargetFqdn, SourceAddress, TargetAddress,
// SourcePort, TargetPort, Network, Protocol,
// Generated, Score, Rtt
using TRow = std::tuple<
    ui64, ui64, TString, TString,
    ui16, ui16, ui8, ui8,
    ui64, double, double>;

namespace {
    TProbe::TRef RowToProbe(const TRow& row) {
        const auto sourceIface = TGlobalTopology::GetTopologyStorage().FindHostInterface(std::get<0>(row));
        const auto targetIface = TGlobalTopology::GetTopologyStorage().FindHostInterface(std::get<1>(row));
        if (!sourceIface || !targetIface) {
            return nullptr;
        }

        const TIpAddress sourceAddress(std::get<2>(row));
        const TIpAddress targetAddress(std::get<3>(row));

        return TProbe::Make(
            sourceIface,
            targetIface,
            sourceAddress,
            targetAddress,
            std::get<4>(row),  // source port
            std::get<5>(row),  // target port
            TInstant::Seconds(std::get<8>(row)),  // generated
            std::get<9>(row),  // score
            std::get<10>(row) > 0.0 ? std::get<10>(row) * 1000.0 : -1.0  // rtt
        );
    }

    //TVector<TProbe::TRef> ProbesFromCH() {
    //    const char* PROBE_FETCH_QUERY = R"(
    //        SELECT
    //            SourceFqdn,
    //            TargetFqdn,
    //            SourceAddress,
    //            TargetAddress,
    //            SourcePort,
    //            TargetPort,
    //            Network,
    //            Protocol,
    //            toUInt64(Generated),
    //            Score,
    //            Rtt
    //        FROM {tableName}
    //        WHERE (
    //            Generated >= {fromDateTime}
    //            AND Generated <= {toDateTime}
    //            AND Score >= 0
    //        )
    //    )";

    //    const auto host = "yp-netmon-clickhouse-noc-sla-sas-5.sas.yp-c.yandex.net";
    //    const auto port = 9000;
    //    const auto user = "";
    //    const auto password = "";

    //    NClickHouse::TClientOptions options;
    //    options.SetHost(host);
    //    options.SetPort(port);
    //    options.SetUser(user);
    //    options.SetPassword(password);

    //    NClickHouse::TClient client(options);

    //    const auto tableName    = "probes_2019111812";
    //    const auto fromDateTime = "toDateTime('2019-11-18 12:13:10')";
    //    const auto toDateTime   = "toDateTime('2019-11-18 12:14:00')";
    //    TString query(PROBE_FETCH_QUERY);
    //    SubstGlobal(query, "{tableName}", tableName);
    //    SubstGlobal(query, "{fromDateTime}", fromDateTime);
    //    SubstGlobal(query, "{toDateTime}", toDateTime);

    //    TVector<TProbe::TRef> probes;
    //    client.Select(query, [&probes] (const NClickHouse::TBlock& block) {
    //        const TVector<TRow> rows(TranslateClickhouseBlock<TRow>(block));
    //        for (const auto& row : rows) {
    //            auto probe(RowToProbe(row));
    //            if (probe) {
    //                probes.emplace_back(probe);
    //            }
    //        }
    //    });

    //    return probes;
    //}

    TVector<TProbe::TRef> ProbesFromFile(const TString& filename) {
        TFileInput input(filename);
        TString line;

        TVector<TProbe::TRef> probes;
        while (input.ReadLine(line)) {
            TVector<TString> tokens = StringSplitter(line).Split('\t');

            TRow row(
                FromString<ui64>(tokens[0]),
                FromString<ui64>(tokens[1]),
                tokens[2],
                tokens[3],
                FromString<ui16>(tokens[4]),
                FromString<ui16>(tokens[5]),
                FromString<ui8>(tokens[6]),
                FromString<ui8>(tokens[7]),
                FromString<ui64>(tokens[8]),
                FromString<double>(tokens[9]),
                FromString<double>(tokens[10])
            );

            auto probe(RowToProbe(row));
            if (probe) {
                probes.emplace_back(probe);
            }
        }

        return probes;
    }
}

int main()
{
    const auto& topologyStorage(TGlobalTopology::GetTopologyStorage());
    const auto topologySelector(topologyStorage.GetTopologySelector());

    TProbeSliceKey sliceKey(BACKBONE6, UDP, 0);
    TProbeStorage::TRef probeStorage(TProbeStorage::Make(sliceKey, topologyStorage));

    const auto filename = "probes.tsv";
    auto probes(ProbesFromFile(filename));
    const auto now(TInstant::ParseIso8601("2019-11-18 18:47:00 +03"));
    probeStorage->InsertProbes(std::move(probes), now);

    TExpressionId defaultExpression = topologyStorage.DefaultExpressionId();
    const TTopologyStorage::THostSetBox seenHosts;
    const TTopologyStorage::THostSetBox terminatedHosts;
    const TTopologyStorage::THostSetBox deadHosts;
    auto switchIndexMap(
        probeStorage->CreateSwitchIndexMap<TProbeStorage::TSwitchIndexAccessor>(
            seenHosts.Get(), terminatedHosts.Get(), deadHosts.Get()));
    TSwitchPairIndex::TRef switchIndex(switchIndexMap->find(defaultExpression)->second);
    TLinePairIndex::TRef queueIndex(TLinePairIndex::Make(
        *topologySelector, *switchIndex, TProbeAggregatorKey::FromSliceKey(sliceKey, defaultExpression)));

    //auto switch1(topologyStorage.FindSwitch("sas", "sas1.4", "sas1-s3"));
    //auto switch2(topologyStorage.FindSwitch("sas", "sas1.4", "sas1-s595"));
    //TSwitchPairKey key(switch2, switch1);
    //for (auto it(switchIndex->GetTree().Begin()); it != switchIndex->GetTree().End(); ++it) {
    //    if (it->GetKey() == key) {
    //        Cout << it->GetProbeCount() << Endl;
    //        auto connectivityHgram = it->GetConnectivityHistogram();
    //        auto connectivity = connectivityHgram.GetValues();
    //        Cout << connectivityHgram.WeightAccumulator << Endl;
    //        for (const auto idx : xrange(connectivity->size())) {
    //            Cout << " " << connectivity->at(idx);
    //        }
    //        Cout << Endl;
    //    }
    //}

    auto queue(topologyStorage.FindQueue("sas", "sas1.4"));
    for (auto it(queueIndex->GetTree().Begin()); it != queueIndex->GetTree().End(); ++it) {
        //auto connectivity = it->GetConnectivityHistogram().GetValues();
        //Cout << it->GetKey() << ":";
        //for (const auto idx : xrange(connectivity->size())) {
        //    Cout << " " << connectivity->at(idx);
        //}
        //Cout << Endl;
        if (it->GetKey() == TLinePairKey(queue, queue)) {
            Cout << it->GetProbeCount() << Endl;
            auto connectivityHgram = it->GetConnectivityHistogram();
            auto connectivity = connectivityHgram.GetValues();
            for (const auto idx : xrange(connectivity->size())) {
                Cout << " " << connectivity->at(idx);
            }
            Cout << Endl;
        }
    }

    return 0;
}
