#pragma once

#include <infra/netmon/topology/settings.h>
#include <infra/netmon/settings.h>

#include <util/system/file.h>
#include <util/stream/file.h>
#include <util/system/env.h>

namespace {
    void LoadSettings(const TString& filename) {
        const TFile configFile(filename, EOpenModeFlag::OpenExisting | EOpenModeFlag::RdOnly | EOpenModeFlag::Seq);
        TFileInput configFileBuffer(configFile);
        NConfig::TGlobals globals;
        NConfig::TConfig config = NConfig::TConfig::FromJson(configFileBuffer, globals);
        NNetmon::TLibrarySettings::Get()->Load(config);
        NNetmon::TTopologySettings::Get()->Load(config);
        NNetmon::TSettings::Get()->Load(config);
    }
}
