LIBRARY()

OWNER(g:netmon)

SRCS(
    api/aggregator_api.cpp
    api/aggregator_request.cpp
    api/client_api.cpp
    api/common_api.cpp
    api/expression_api.cpp
    api/history_api.cpp
    api/network_availability_api.cpp
    api/probes_api.cpp
    api/slicer_api.cpp
    api/state_api.cpp
    api/tasks_api.cpp
    history_requester.cpp
    infra.cpp
    link_poller_hosts.cpp
    metrics.cpp
    metrics_updater.cpp
    monitors.cpp
    network_availability.cpp
    probe.cpp
    probe_aggregator.cpp
    probe_aggregator_maintainer.cpp
    probe_dumper.cpp
    probe_scheduler.cpp
    probe_schedule_maintainer.cpp
    probe_slice.cpp
    probe_slice_dumper.cpp
    probe_slice_history.cpp
    probe_slice_maintainer.cpp
    probe_slice_merger.cpp
    probe_storage.cpp
    schema_maintainer.cpp
    seen_hosts.cpp
    settings.cpp
    share_dead_hosts.cpp
    slice_collector.cpp
    state_index.cpp
    state_index_history.cpp
    state_keys.cpp
    state_picker.cpp
    switch_metrics.cpp
    racktables.cpp
    terminated_hosts.cpp
    user_data_storage.cpp
)

IF (NOC_SLA_BUILD)
    CXXFLAGS(-DNOC_SLA_BUILD)
ENDIF()

PEERDIR(
    infra/netmon/agent/idl
    infra/netmon/expression
    infra/netmon/idl
    infra/netmon/library
    infra/netmon/statistics
    infra/netmon/tasks
    infra/netmon/topology
    library/cpp/monlib/encode/json
    library/cpp/monlib/encode/spack
    library/cpp/monlib/metrics
    library/cpp/on_disk/coded_blob
    library/cpp/on_disk/mms
    library/cpp/threading/light_rw_lock
)

END()

RECURSE(
    agent
    aggregator
    build_topology
    expression
    idl
    library
    resolver
    slicer
    statistics
    tasks
    topology
    ut
    utils
)

IF (OS_LINUX)
    RECURSE(
        tests
    )
ENDIF()
