#!/bin/bash

# examples:
#
# ./create_sa.sh preprod-fed-user preprod-netmon-sa api.cloud-preprod.yandex.net:443
# ./create_sa.sh prod-fed-user prod-netmon-sa api.cloud.yandex.net:443

FED_USER=$1
SA_NAME=$2
ENDPOINT=$3

CLOUD_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cloud)
FOLDER_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_folder)

yc config profile activate $FED_USER

SERVICE_ACCOUNT_ID=$(yc iam service-account create --name $SA_NAME --description "Service account for Netmon cloud" | head -n1 | cut -d' ' -f2)
yc resource-manager folder add-access-binding $FOLDER_ID --role editor --subject serviceAccount:$SERVICE_ACCOUNT_ID
yc iam key create --service-account-name $SA_NAME --output $SA_NAME.json

yc config profile create $SA_NAME
yc config set service-account-key $SA_NAME.json
yc config set cloud-id $CLOUD_ID
yc config set folder-id $FOLDER_ID
yc config set endpoint $ENDPOINT

yc config profile activate $FED_USER
