#!/bin/bash

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

usage() {
    echo >&2 "Usage: $0 [prod|preprod]"
    echo >&2
    echo >&2 "This script requires prod-fed-user and preprod-fed-user accounts to exist."
}

STAGE=${1:-"prod"}
case $STAGE in
    prod) FED_USER=prod-fed-user;;
    preprod) FED_USER=preprod-fed-user;;
    *) usage; exit 1;;
esac

yc config profile activate $FED_USER

CLOUD_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cloud)
FOLDER_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_folder)
CR_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cr --folder-id $FOLDER_ID)

SA_NAME=assembly-workshop-sa
SA_KEY_PATH=${SA_NAME}-key.json

yc iam service-account create --name $SA_NAME --folder-id $FOLDER_ID --description "Service account for Assembly Workshop"
yc iam key create --service-account-name $SA_NAME --output $SA_KEY_PATH --folder-id $FOLDER_ID

yc container registry add-access-binding $CR_ID --role container-registry.images.puller --service-account-name $SA_NAME --folder-id $FOLDER_ID
yc container registry add-access-binding $CR_ID --role container-registry.images.pusher --service-account-name $SA_NAME --folder-id $FOLDER_ID

yc config profile activate prod-fed-user  # only prod user has access to AW cloud
AW_CLOUD_ID=b1ggfg2aokc1b7ead930  # yc-assembly-workshop
AW_FOLDER_NAME=bench-netmon
SECRET_PAYLOAD=$(<$SA_KEY_PATH jq -nc '[{key: "key", text_value: $val}]' --rawfile val $SA_KEY_PATH)
SECRET_ID=$(echo $SECRET_PAYLOAD \
    | yc lockbox --cloud-id $AW_CLOUD_ID --folder-name $AW_FOLDER_NAME secret create --name "$SA_NAME-key-$STAGE" \
                 --description "Authorized key for $SA_NAME in $STAGE netmon cloud" --payload - \
    | yq -r .id)
rm $SA_KEY_PATH

echo "$SA_NAME key was stored in lockbox secret $SECRET_ID. Copy this id to DOCKER_REGISTRY_SA_SECRET_ID env var in Teamcity builds."
$ARCADIA_ROOT/infra/netmon/yc/kube/activate.sh $STAGE
