#!/bin/bash

# usage:
#
# ./setup_external_secrets_sa.sh preprod-fed-user

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

FED_USER=$1

CLOUD_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cloud)
FOLDER_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_folder)

ESO_ACCOUNT=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_external_secrets_sa)
ESO_ACCOUNT_KEY=$ESO_ACCOUNT.json

yc config profile activate $FED_USER

yc iam service-account create --name $ESO_ACCOUNT --folder-id $FOLDER_ID --description "Service account for external-secrets"
yc iam key create --service-account-name $ESO_ACCOUNT --output $ESO_ACCOUNT_KEY --folder-id $FOLDER_ID
echo "Authorized key for $ESO_ACCOUNT saved in $ESO_ACCOUNT_KEY. Store it in YaV."

yc lockbox secret add-access-binding --name "netmon-tokens" \
    --service-account-name $ESO_ACCOUNT --folder-id $FOLDER_ID --role lockbox.payloadViewer
