#!/bin/bash

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

if [[ $# -ne 1 ]]; then
    echo "Usage: $0 service_dir"
    exit 1
fi

SVC=$1
SVC=${SVC%/}  # remove trailing slash if present

if [ ! -d $SVC ]; then
    echo "Service $SVC doesn't exist"
    exit 1
fi

if [ -f $SVC/prepare.sh ]; then
    cd $SVC
    ./prepare.sh
    cd ..
fi

DOCKERFILE=$SVC/Dockerfile

CR_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cr)
CR_ADDR=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cr_address)

sed -e "s/\<CR_ID_PLACEHOLDER\>/$CR_ID/g" -e "s/\<CR_ADDR_PLACEHOLDER\>/$CR_ADDR/g" $DOCKERFILE \
    | docker build --network host --tag $CR_ADDR/$CR_ID/$SVC:latest -f- .
