#!/bin/bash

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

CR_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cr)
CR_ADDR=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_cr_address)

build() {
    PKG=$1
    SVC=$2

    cd $SVC
    cp ./Dockerfile.template ./Dockerfile
    sed --in-place -e "s/\<CR_ID_PLACEHOLDER\>/$CR_ID/g" -e "s/\<CR_ADDR_PLACEHOLDER\>/$CR_ADDR/g" ./Dockerfile
    #if [[ "$SVC" == "yandex-netmon-noc-sla-server" ]]; then
    #    ../_get_last_sb_resource.sh NETMON_CLOUD_PREPROD_TOPOLOGY
    #fi
    cd ..

    ya package --docker $PKG --docker-registry $CR_ADDR --docker-repository $CR_ID
    REPOSITORY=$CR_ADDR/$CR_ID/$SVC
    LATEST_TAG=$(docker images $REPOSITORY --format "{{.Tag}}" | head -n1)
    docker tag $REPOSITORY:$LATEST_TAG $REPOSITORY:latest
}

build ../../pkg/noc_sla_yc.json yandex-netmon-noc-sla-server
#build ../../pkg/agent.json yandex-netmon-agent
