handle_error() {
    local error_code=$1
    local line_number=$2
    local file=$3
    echo >&2 "$(basename $file):$line_number: command exited with code $error_code"
    echo -n >&2 "  "; sed  >&2 -n -e "${line_number}p" $file
}

check_errors() {
    set -eEuo pipefail
    trap 'handle_error $? $LINENO $BASH_SOURCE' ERR
}

ignore_errors() {
    set +eEuo pipefail
    trap '' ERR
}

check_errors
