#!/bin/bash

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

if [[ ${1:-} != preprod && ${1:-} != prod ]]; then
    echo >&2 "Usage: $0 <preprod|prod>"
    echo >&2 "Note: this script expects yc profiles preprod-netmon-sa, prod-netmon-sa"
    echo >&2 "      and ycp profiles preprod, prod"
    exit 1
fi

if [[ $1 = prod ]]; then
    YCP_PROFILE=prod
    YC_PROFILE=prod-netmon-sa
    KUBE_CONTEXT=prod-yc-netmon
else
    YCP_PROFILE=preprod
    YC_PROFILE=preprod-netmon-sa
    KUBE_CONTEXT=preprod-yc-netmon
fi

YCP_CONFIG=~/.config/ycp/config.yaml
if [[ -e $YCP_CONFIG ]]; then
    need_backup=1
    for backup in $YCP_CONFIG.backup*; do
        if diff $YCP_CONFIG $backup &>/dev/null; then
            need_backup=0
            break
        fi
    done
    if [[ $need_backup = 1 ]]; then
        echo >&2 "Backing up $YCP_CONFIG"
        cp -v --backup=numbered $YCP_CONFIG{,.backup}
    fi
fi

yc config profile activate $YC_PROFILE
sed -i -e "s/current-profile: .*/current-profile: $YCP_PROFILE/" ~/.config/ycp/config.yaml
kubectl config use-context $KUBE_CONTEXT
