#!/bin/bash

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

if [[ $# != 0 && $# != 2 && $# != 4 ]]; then
    echo >&2 "Usage: $0"
    echo >&2 "optionally: specify yc profiles:         $0 preprod-netmon-sa prod-netmon-sa"
    echo >&2 "            specify yc and ycp profiles: $0 preprod-netmon-sa prod-netmon-sa preprod prod"
    exit 1
fi

YC_PREPROD=${1:-"preprod-netmon-sa"}
YC_PROD=${2:-"prod-netmon-sa"}
YCP_PREPROD=${3:-"preprod"}
YCP_PROD=${4:-"prod"}

# check that profiles exist
yc config profile get $YC_PREPROD &>/dev/null
yc config profile get $YC_PROD &>/dev/null

if [ -e ~/.kube/config ]; then
    echo >&2 "Backing up ~/.kube/config"
    mv -v --backup=numbered ~/.kube/config{,.backup}
fi

yc config profile activate $YC_PREPROD
PREPROD_K8S_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_k8s)
PREPROD_K8S_INTERNAL_ENDPOINT=$(yc k8s cluster get $PREPROD_K8S_ID | yq -r '.master.endpoints.internal_v4_endpoint')
PREPROD_K8S_SERVICE_ENDPOINT=$(ycp k8s cluster get $PREPROD_K8S_ID --profile $YCP_PREPROD | yq -r '.master.endpoints.service_v6_endpoint')
yc k8s cluster get-credentials $PREPROD_K8S_ID --internal --context-name preprod-yc-netmon

yc config profile activate $YC_PROD
PROD_K8S_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_k8s)
PROD_K8S_INTERNAL_ENDPOINT=$(yc k8s cluster get $PROD_K8S_ID | yq -r '.master.endpoints.internal_v4_endpoint')
PROD_K8S_SERVICE_ENDPOINT=$(ycp k8s cluster get $PROD_K8S_ID --profile $YCP_PROD | yq -r '.master.endpoints.service_v6_endpoint')
yc k8s cluster get-credentials $PROD_K8S_ID --internal --context-name prod-yc-netmon

cat ~/.kube/config \
    | yq --yaml-output \
        "(..|select(.server? == \"$PREPROD_K8S_INTERNAL_ENDPOINT\")) +=
         {\"server\": \"$PREPROD_K8S_SERVICE_ENDPOINT\"}" \
    | yq --yaml-output \
        "(..|select(.server? == \"$PROD_K8S_INTERNAL_ENDPOINT\")) +=
         {\"server\": \"$PROD_K8S_SERVICE_ENDPOINT\"}" \
    >~/.kube/config.tmp
mv -v ~/.kube/config.tmp ~/.kube/config

echo >&2 "~/.kube/config generated"

$ARCADIA_ROOT/infra/netmon/yc/kube/activate.sh preprod
