#!/bin/bash

source $ARCADIA_ROOT/infra/netmon/yc/error_reporting.sh

kill $(pgrep -f 'sshuttle --ssh-cmd pssh') >> /dev/null 2>&1 || true

K8S_ID=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_k8s)
yc managed-kubernetes cluster get-credentials $K8S_ID --internal --force >> /dev/null 2>&1

DNS_ZONE=$($ARCADIA_ROOT/infra/netmon/yc/manage_cloud.sh get_dns_zone)
JUMP_HOST=netmon-frontend-ru-central1-a.$DNS_ZONE

pssh $JUMP_HOST true

echo "Making sshuttle to $JUMP_HOST..."
nohup sshuttle --ssh-cmd pssh -r admin@$JUMP_HOST 172.16.0.0/24 &
