import logging
import threading
import time
from threading import Thread


class Component(Thread):
    def __init__(self, context, config=None):
        super(Component, self).__init__()
        self.context = context
        self.config = config or {}
        self.daemon = True
        self.running = True
        self.lock = threading.RLock()

    def init(self):  # type: () -> None
        """ for post-construct """
        pass

    def run(self):  # type: () -> None
        while self.running:
            try:
                self.loop()
            except:
                logging.exception('exception in component loop')
            time.sleep(0.1)

    def loop(self):  # type: () -> None
        raise NotImplementedError("not implemented")

    def stop(self):  # type: () -> None
        self.running = False

    def get_component(self, name):  # type: (str) -> Component
        return self.context['components'].get(name)

    def get_state(self):  # type: () -> str
        return '?'
