import json
import logging
import os
import sys

from .abstract import PlainModule, iso_date

LOG = logging.getLogger(__name__)

LOG_NAME = '/var/chef/last_run.log'


class AgentModule(PlainModule):
    def get_value(self):
        if not os.path.isfile(LOG_NAME):
            return None
        with open(LOG_NAME, 'r') as f:
            s = f.read().strip()
        return self.format_answer('chef', self.parse(s))

    def parse(self, s):
        res = {}
        t, msg = map(lambda x: x.strip(), s.split(':', 1))
        res['start'], res['stop'] = map(lambda x: iso_date(int(x.strip())), t.split(','))
        res['msg'] = msg
        res['ok'] = msg.startswith('OK')
        return res


if __name__ == '__main__':
    logging.basicConfig(level='INFO')
    print json.dumps(AgentModule(sys.platform).get_value(), indent=4)
