import json
import os
import sys

from .abstract import PlainModule


# Deprecated
class AgentModule(PlainModule):
    def get_value(self):
        base = '/dev/disk/by-partlabel'
        result = []
        if not os.path.isdir(base):
            raise Exception('Not a directory: {}'.format(base))

        for fn in os.listdir(base):
            if not fn.startswith('platform_'):
                continue

            disk_info = {
                'device': os.path.join(base, fn)
            }

            blk = os.readlink(os.path.join(base, fn))
            if not blk.startswith('/'):
                blk = os.path.join(base, blk)
            blk_stat = os.stat(blk)
            blk_mm = '{}:{}'.format(os.major(blk_stat.st_rdev), os.minor(blk_stat.st_rdev))
            sys_blk = os.readlink('/sys/dev/block/{}'.format(blk_mm)).replace('../../', '/sys/')

            with open(os.path.join(sys_blk, '..', 'queue', 'logical_block_size'), 'r') as f:
                sector = int(f.read().strip())
                with open(os.path.join(sys_blk, 'size'), 'r') as f2:
                    disk_info['size'] = sector * int(f2.read().strip())

            with open(os.path.join(sys_blk, '..', 'queue', 'rotational'), 'r') as f3:
                if f3.read().strip() == '0':
                    disk_info['type'] = 'SSD'
                else:
                    disk_info['type'] = 'HDD'

            disk_info['deviceNumber'] = blk_mm
            result.append(disk_info)

        return self.format_answer('disks', {'disks': result}) if result else None


if __name__ == '__main__':
    print json.dumps(AgentModule(sys.platform).get_value(), indent=4)
