# coding: utf-8

import json
import logging
import sys

from .abstract import PlainModule, run_command

# will use this keys from lldpctl output. only first two parts will be used in result structure
data_keys = ['chassis.mac', 'chassis.name', 'chassis.descr', 'port.ifname', 'port.descr',
             'port.auto-negotiation.current']


class AgentModule(PlainModule):

    def get_value(self):
        # no xml here, we can't rely on external deps
        lldp_result = run_command('sudo /usr/sbin/lldpctl -f keyvalue', timeout_sec=120)

        if lldp_result.returncode != 0:
            raise Exception('LLDP return code is {}'.format(lldp_result.returncode))

        # some chassis has long descriptions with \r\n delimiters
        lldp_result = lldp_result.out.replace("\r\n", "\r")

        ifaces = {}
        for line in lldp_result.split("\n"):
            if not line.startswith('lldp.'):
                continue

            key, value = line.split('=', 2)
            parts = key.split('.')[1:]
            iface = parts[0]

            data_key = ".".join(parts[1:])
            if data_key in data_keys:
                # make me cry, python!
                if iface not in ifaces:
                    ifaces[iface] = {'name': iface}
                if parts[1] not in ifaces[iface]:
                    ifaces[iface][parts[1]] = {}
                ifaces[iface][parts[1]][parts[2]] = value.replace("\r", "\n")

        result = []
        for iface in ifaces.keys():
            result.append(ifaces[iface])

        return self.format_answer('lldp', {'interfaces': result})


if __name__ == '__main__':
    logging.basicConfig(level='INFO')
    print json.dumps(AgentModule(sys.platform).get_value(), indent=4)
