import json
import logging
import re
import sys
import traceback

from .abstract import PlainModule, run_command, gauge

LOG = logging.getLogger(__name__)


class AgentModule(PlainModule):
    def get_value(self):
        result = {}

        if self.arch.startswith('linux'):
            try:
                with open('/proc/loadavg', 'r') as f:
                    s = f.read().split()
                result = gauge('LoadAverage', None, None, float(s[0]), float(s[0]), float(s[2]))
            except:
                self.warnings.log("failed to read /proc/loadavg: %s", traceback.format_exc())

        elif self.arch.startswith('freebsd'):
            s = run_command('sysctl vm.loadavg').out
            r = re.search(r'vm.loadavg: { ([\d.]+) ([\d.]+) ([\d.]+) }', s)
            if r:
                result = gauge('LoadAverage', None, None, float(r.group(1)), float(r.group(2)), float(r.group(3)))

        return self.format_answer('loadavg', result) if result else None


if __name__ == '__main__':
    logging.basicConfig(level='INFO')
    print json.dumps(AgentModule(sys.platform).get_value(), indent=4)
