import json
import logging
import re
import sys
import traceback

from .abstract import PlainModule, run_command

LOG = logging.getLogger(__name__)


class AgentModule(PlainModule):
    def get_value(self):
        try:
            s = run_command('/place/mapreduce/mapreduce -version').out
            r = re.search(r'mapreduce\s+(\S+)', s)
            if r:
                version = r.group(1)

                self.warnings = None
                return self.format_answer('mapreduce', {'version': version})
        except:
            self.warnings.log("Failed to get `mapreduce` version: %s", traceback.format_exc())

        return None


if __name__ == '__main__':
    logging.basicConfig(level='INFO')
    print json.dumps(AgentModule(sys.platform).get_value(), indent=4)
