# coding: utf-8

import json
import logging
import re
import sys
import time
import traceback

from .abstract import PlainModule, run_command, iso_date, gauge

LOG = logging.getLogger(__name__)


def parse_answer(lines):
    cpu_temp = {}

    n = 0
    cpu = '?'
    for s in lines:
        if s.startswith('coretemp'):
            cpu = "cpu%s" % n
            n += 1
        r = re.search(r'Core (\d):\s+\+([\d.]+)', s)
        if r:
            key = cpu + "core" + r.group(1)
            cpu_temp[key] = float(r.group(2))
    return cpu_temp


class AgentModule(PlainModule):
    def get_value(self):
        observation_time = iso_date(time.time())

        res = {}
        if self.arch.startswith('linux'):
            try:
                res = parse_answer(run_command('sensors', lines=True).out)
            except Exception:
                self.warnings.log("failed sensors parse failed: %s", traceback.format_exc())

        elif self.arch.startswith('freebsd'):
            for l in run_command('sysctl dev.cpu', lines=True).out:
                r = re.search(r'dev\.cpu\.(.+)\.temperature: ([\d.]+)C', l)
                if r:
                    res['cpu_%s' % r.group(1)] = float(r.group(2))

        result = {}
        if res:
            gauges = {}
            for key, val in res.items():
                gauges[key] = gauge(key, observation_time, val)
            result = {'gauges': gauges}

        return self.format_answer('temperature', result) if result else None


if __name__ == '__main__':
    logging.basicConfig(level='INFO')
    print json.dumps(AgentModule(sys.platform).get_value(), indent=4)
