import datetime
import json
import logging
import sys
import time

from .abstract import ThreadedModule, iso_date, run_command, event

LOG = logging.getLogger(__name__)


class AgentModule(ThreadedModule):
    sessions = {}
    change_time = 0

    def loop(self):
        for s in run_command('who', lines=True).out:
            ss = s.strip().split()
            if len(ss) > 1:
                login = ss[0]
                self.sessions[login] = iso_date()
            self.change_time = datetime.datetime.utcnow()

    def get_value(self):
        res = []
        for k, v in self.sessions.iteritems():
            res.append(event('', k, v, reg_time=iso_date(self.change_time)))

        return self.format_answer('who', {'events': res}) if res else None


if __name__ == '__main__':
    logging.basicConfig(level='INFO')
    module = AgentModule(sys.platform)
    module.start()
    time.sleep(2)
    print json.dumps(module.get_value(), indent=4)
    module.stop()
