![owl](./owl.jpg)

## Сервис аварийного ограничения действий
Основная цепочка развития аварий на кластере выглядит так:
  * Человек производит ошибочное действие (коммит, выкладка, запуск операции).  
  Логическая ошибка в коде, слишком большая выборка объектов для выполнения операции (sky run).
  * В результате большое количество "акторов" начинает одновременные действия.
  * Кластер складывается в течение единиц, максимум - десятков минут.

Урон от аварий складывается из нескольких вещей, в данном рассуждении нам интересны следующие:
  * Частота ошибок (вероятность)  
  Чем реже ошибаемся, тем меньше урон от действий.
  * "Радиус поражения" - количество объектов, затронутых аварией.
  Например, "все iss-agent'ы VLA" или "все хосты yabs_frontend".

Убрать человеческие ошибки полностью не представляется возможным (но работы по снижению ведутся), но нас интересует задача уменьшения радиуса поражения при ошибках.

## Почему радиус поражения большой?
Штатно все действия в системе должны выполняться "оркестировано", т.е. даже взрывоопасные изменения должны применяться плавно так, что "мгновенно" всё не отключится/не сломается/не выкатится. Но, тут реальность вторгается в стройную картину:
  * Не у всех сервисов есть оркестрация.
  salt - очень яркий пример, хочется так же автоматизировать настройки netconfig - у него оркестрации тоже нет.
  * Оркестраторы - сложные сущности, в которых можно допустить ошибку.
  * Есть объекты, над которыми работает несколько "акторов" и им необходимо координироваться.
  Например, не забирать больше N хостов в работу для обновления ядра и применения изменений сети на хосте netconfig'ом.

## Предложение
Создать простой сервис блокировки, куда перед применением сходят акторы и запросят разрешения. В простейшем случае (MVP) - это простой HTTP сервис со следующими объектами:
  * `Rule` - правило с атрибутами:
    * `string id` - имя правила (например, `host_maintenance`)
    * `int32 max_allowed` - максимальное количество сущностей, над которыми выполняется операция
    * `Duration duration` - продолжительность операции (по истечению этого времени операция считается выполненной и освобождает окно)  
  Например, мы говорим, что в правиле максимум 100 объектов (хостов) с длительностью 10 минут на каждый. Таким образом, 1 ДЦ мы уложим за сутки, а не за 20 минут, в случае применения деструктивных изменений.
  * `Operation` - запрос на проведение операции с атрибутами:
    * `string id` - имя объекта (например, `iva1-5791.search.yandex.net`)
    * `string rule` - правило, по которому мы бы хотели произвести операцию.

Штатный workflow:
  * Администратор в лице max7255 создаёт правило `netconfig_apply_routes` и "обучает" netconfig использовать его.
  Т.е. при получении нового списка роутов - сходить по HTTP в сервис и применить только, если ответили 200 OK.
  * Сервис (например, netconfig) получает 200 ОК и выполняет действие.
  Если получили любой другой ответ - завершаем работу, действие не выполняем.
  * Администратор может отслеживать текущие "операции" через API/UI сервиса, в случае проблем может выключить - выставив `max_allowed = 0`.

## Вопросы и ответы
**Вопрос**: Почему пользователи (salt, netconfig) не рапортуют об успехе?

**Ответ**: В будущем это можно поддержать, но текущие пользователи, к сожалению, не могут локально (на хосте) определить, была ли операция выполнена успешно. Например, новые роуты netconfig'а кому-то могут ломать работу, а для других инстансов ничего не поменяется. Об этом можно судить только по продуктовым графикам всех сервисов.

**Вопрос**: Тогда почему бы пользователям не рапортовать о неуспехе?

**Ответ**: Такой вариант прорабатывался и базовая поддержка в схеме данных сервиса есть. Основной вопрос - к пользователям, могут ли они рапортовать об этом. Первые пользователи MVP - нет. Как только они научатся - можно этот вариант добавить с логикой:
  * По таймауту из окна выполняющихся удаляются только операции, которые не отмечены как `FAILED`.
  * Если количество `FAILED` операций сравняется с размером окна - прогресс встанет.
  * Удалить такие операции может только оператор вручную.

