#!/bin/env python
import os
import sys

POD_ID = os.environ['YP_POD_ID']

MAN_PODS = ['cplptii2dg7qig4j.man.yp-c.yandex.net']
SAS_PODS = ['b3blcwjmcm2kbhpk.sas.yp-c.yandex.net', 'jyd2fsnhbktrkq6u.sas.yp-c.yandex.net']
VLA_PODS = ['nhkxeclli2ovmwr2.vla.yp-c.yandex.net', 'pbsocv2ek76juvuk.vla.yp-c.yandex.net']

ALL_PODS = MAN_PODS + SAS_PODS + VLA_PODS

DB_PATH = '/var/lib/etcd'
ETCD_PATH = '/opt/etcd/etcd'


def get_persistent_hostname(pod_id):
    for pod_hostname in ALL_PODS:
        if pod_hostname.startswith(pod_id):
            return pod_hostname
    return None


def make_member_name(pod_id):
    return 'orly-' + pod_id


def make_cmd_line(state):
    cmd = [ETCD_PATH]
    hostname = get_persistent_hostname(POD_ID)
    if hostname is None:
        print "Failed to find hostname for " + POD_ID
        raise SystemExit(1)
    name = make_member_name(POD_ID)
    cmd.append('--name')
    cmd.append('{}'.format(name))
    cmd.append('--listen-peer-urls')
    cmd.append('http://[::]:2380')
    cmd.append('--listen-client-urls')
    cmd.append('http://[::]:2379')
    cmd.append('--initial-advertise-peer-urls')
    cmd.append('http://{}:2380'.format(hostname))
    initial_cluster = []
    for pod in ALL_PODS:
        pod_id = pod.split('.', 1)[0]
        initial_cluster.append('{}=http://{}:2380'.format(make_member_name(pod_id), pod))
    cmd.append('--initial-cluster')
    cmd.append(','.join(initial_cluster))
    cmd.append('--initial-cluster-state')
    cmd.append(state)
    cmd.append('--advertise-client-urls')
    cmd.append('http://{}:2379'.format(hostname))
    cmd.append('--data-dir')
    cmd.append(DB_PATH)
    cmd.append('--quota-backend-bytes')
    cmd.append('-1')
    cmd.append('--auto-compaction-retention')
    cmd.append('1')
    cmd.append('--experimental-backend-bbolt-freelist-type')
    cmd.append('map')
    return cmd


def main():
    cmd = make_cmd_line('existing')
    sys.stdout.write("Executing " + ' '.join(cmd))
    sys.stdout.flush()
    os.execve(cmd[0], cmd, os.environ)


if __name__ == '__main__':
    main()
