package ctl

import (
	"a.yandex-team.ru/infra/orly/go/orly/client"
	"fmt"
	"github.com/spf13/cobra"
	"os"
)

var rootCmd = &cobra.Command{
	Use: "orlyctl",
}

func Execute() error {
	return rootCmd.Execute()
}

func init() {
	var ruleFilename string
	var orlyURL string
	cmdGetRule := &cobra.Command{
		Use:   "get-rule id",
		Short: "Get rule",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			resp, err := GetRule(client.NewClient(orlyURL), args[0])
			if err != nil {
				er(err)
			}
			fmt.Println(resp)
		},
	}

	cmdApplyRule := &cobra.Command{
		Use:   "apply-rule",
		Short: "Apply rule",
		Args:  cobra.NoArgs,
		Run: func(cmd *cobra.Command, args []string) {
			flags := cmd.Flags()
			if !flags.Changed("file") {
				er("argument -f/--file is required")
				return
			}
			resp, err := ApplyRule(client.NewClient(orlyURL), ruleFilename)
			if err != nil {
				er(err)
			}
			fmt.Println(resp)
		},
	}

	cmdDeleteRule := &cobra.Command{
		Use:   "delete-rule id",
		Short: "Delete rule",
		Args:  cobra.ExactArgs(1),
		Run: func(cmd *cobra.Command, args []string) {
			id := args[0]
			resp, err := DeleteRule(client.NewClient(orlyURL), id)
			if err != nil {
				er(err)
			}
			fmt.Println(resp)
		},
	}

	cmdOperation := &cobra.Command{
		Use:   "operation",
		Short: "Start operation",
		Args:  cobra.NoArgs,
		Run: func(cmd *cobra.Command, args []string) {
			flags := cmd.Flags()
			if !flags.Changed("file") {
				er("argument -f/--file is required")
				return
			}
			resp, err := StartOperation(client.NewClient(orlyURL), ruleFilename)
			if err != nil {
				er(err)
			}
			fmt.Println(resp)
		},
	}

	cmdApplyRule.Flags().StringVarP(&ruleFilename, "file", "f", "", "File to get rule from")
	cmdOperation.Flags().StringVarP(&ruleFilename, "file", "f", "", "File to get rule from")
	rootCmd.AddCommand(cmdGetRule)
	rootCmd.AddCommand(cmdApplyRule)
	rootCmd.AddCommand(cmdDeleteRule)
	rootCmd.AddCommand(cmdOperation)
	rootCmd.PersistentFlags().StringVar(&orlyURL, "url", client.URLProduction, "O'RLY server url.")
}

func er(msg interface{}) {
	fmt.Println("Error:", msg)
	os.Exit(1)
}
