import gevent.lock

from infra.orly.lib import climit


class LimitedQueueSemaphore(object):
    __slots__ = ['_climit', '_lock']
    ERR_CONCURRENT_WAITERS_LIMIT_REACHED = 'concurrent waiters limit reached'
    ERR_TIMEOUT_REACHED = 'lock timeout reached'

    def __init__(self, limit):
        self._climit = climit.CLimit(limit)
        self._lock = gevent.lock.Semaphore()

    def acquire(self, timeout=5):
        if not self._climit.add():
            return self.ERR_CONCURRENT_WAITERS_LIMIT_REACHED
        if not self._lock.acquire(timeout=timeout):
            self._climit.done()
            return self.ERR_TIMEOUT_REACHED
        return None

    def release(self):
        self._lock.release()
        self._climit.done()

    def __str__(self):
        return "QueueLimitedSemaphore(climit={},lock={})".format(self._climit, self._lock)
