def match(selector, op):
    if selector is None:
        return None
    op_labels = op.meta.labels
    for m_in in selector.match_in:
        if m_in.key not in op_labels:
            return "no key='{}' in op labels".format(m_in.key)
        if op_labels[m_in.key] not in m_in.values:
            return "label {}={} did not match selector values: {}".format(m_in.key,
                                                                          op_labels[m_in.key],
                                                                          m_in.values)
    return None
