import datetime


def hh_mm_to_minutes(hhmm):
    hh, mm = hhmm.split(':', 1)
    return int(mm) + int(hh) * 60


def weekday_and_minutes(now_func=datetime.datetime.utcnow, utc_offset_hours=3):
    """
    Returns current weekday index (MON is 0) and minutes since midnight.

    Default utc_offset_hours is 3 - Moscow time (local time on servers).
    """
    now = now_func() + datetime.timedelta(hours=utc_offset_hours)
    return now.weekday(), now.minute + now.hour * 60
