import datetime

from gevent import pywsgi


class WSGIHandler(pywsgi.WSGIHandler):
    def format_request(self):
        """
        Overridden to try to log client address from headers.
        """
        now = datetime.datetime.utcnow()
        length = self.response_length or '-'
        if self.time_finish:
            delta = '%.6f' % (self.time_finish - self.time_start)
        else:
            delta = '-'
        if self.environ is not None and 'HTTP_X_FORWARDED_FOR' in self.environ:
            # Good case: we have X-Forwarded-For
            fwd = self.environ['HTTP_X_FORWARDED_FOR']
            index = fwd.find(',')
            if index != -1:
                client_address = fwd[:index]
            else:
                client_address = fwd
        else:
            client_address = self.client_address[0] if isinstance(self.client_address, tuple) else self.client_address
        return '%s - - [%s] "%s" %s %s %s' % (
            client_address or '-',
            now,
            getattr(self, 'requestline', ''),
            self.code,
            length,
            delta)
