import requests

# from infra.oxcart.proto.awacs import api_pb2

from infra.awacs.proto import api_pb2


def failure(error, message, code):
    return api_pb2.Status(status='Failure', error=error, message=message, code=code)


class AwacsClient(object):
    HEADERS = {
        'Content-Type': 'application/x-protobuf',
        'Accept': 'application/x-protobuf',
        'User-Agent': 'endpoint_agent',
    }
    PROD_URL = 'https://awacs.yandex-team.ru'

    def __init__(self, url=PROD_URL):
        url = url.rstrip('/')
        self.url = url + '/api/'

    def _call(self, method, request, response):
        h = self.HEADERS.copy()
        url = self.url + method + '/'
        try:
            resp = requests.post(url,
                                 data=request.SerializeToString(),
                                 headers=h,
                                 timeout=10)
        except Exception as e:
            return None, failure('CallFailed', 'request failed: {}'.format(e), 500)
        if resp.status_code == 200:
            # Try to parse response
            try:
                response.MergeFromString(resp.content)
            except Exception as e:
                return None, failure('InvalidResponse',
                                     'failed to parse response: {}'.format(e),
                                     code=500)
            return response, None
        # Try to parse error response
        status = api_pb2.Status()
        try:
            status.MergeFromString(resp.content)
        except Exception as e:
            return None, failure('InvalidResponse',
                                 'bad code={}, failed to parse response: {}'.format(resp.status_code, e),
                                 resp.status_code)
        return None, status

    def get_endpoint_set(self, namespace_id, id_):
        request = api_pb2.GetEndpointSetRequest()
        request.id = id_
        request.namespace_id = namespace_id
        response = api_pb2.GetEndpointSetResponse()
        return self._call('GetEndpointSet', request, response)

    def get_backend(self, namespace_id, id_):
        request = api_pb2.GetBackendRequest()
        request.id = id_
        request.namespace_id = namespace_id
        response = api_pb2.GetBackendResponse()
        return self._call('GetBackend', request, response)

    def get_upstream(self, namespace_id, id_):
        request = api_pb2.GetUpstreamRequest()
        request.id = id_
        request.namespace_id = namespace_id
        response = api_pb2.GetUpstreamResponse()
        return self._call('GetUpstream', request, response)

    def get_balancer(self, namespace_id, id_):
        request = api_pb2.GetBalancerRequest()
        request.id = id_
        request.namespace_id = namespace_id
        response = api_pb2.GetBalancerResponse()
        return self._call('GetBalancer', request, response)
