from infra.oxcart.proto import config_pb2
from google.protobuf import json_format
import logging


log = logging.getLogger('config')


def _default_config():
    c = config_pb2.Config()

    c.runtime_type = config_pb2.Config.CHILD
    c.envoy_user = 'loadbase'
    c.proxy_cmdline_template = "{binary} -c {config}"
    c.proxy_config_path = "config/envoy.yaml"
    c.proxy_binary_path = "external/envoy-static"
    c.engine_type = config_pb2.Config.ENVOY
    c.cluster_refresh_period = 10
    c.proxy_check_period = 1
    c.its_check_period = 10

    return c


def get_config(path):
    c = _default_config()
    c2 = config_pb2.Config()

    try:
        with open(path) as f:
            json_format.Parse(f.read(), c2)
    except:
        pass
        log.exception('Failed to parse config')

    c.MergeFrom(c2)
    print c

    return c
