import time
import uuid
import socket
import grpc
import logging
import envoy.api.v2.cds_pb2_grpc as cds_grpc
import envoy.api.v2.lds_pb2_grpc as lds_grpc
import envoy.api.v2.cds_pb2 as cds_pb2
import envoy.api.v2.core.address_pb2 as address_pb2
import envoy.api.v2.discovery_pb2 as discovery_pb2
from infra.oxcart.lib import cluster


from concurrent import futures

log = logging.getLogger('envoy_grpc')

class ListenerDiscoveryServiceServicer(lds_grpc.ListenerDiscoveryServiceServicer):
    def __init__(self, cluster_state):
        self.version = 0
        self.nonce = None
        self.cluster_state = cluster_state
        self.envoy_listeners = None

    def StreamListeners(self, request_iterator, context):
        for req in request_iterator:

            while True:
                self.version, ls = self.cluster_state.render_envoy_listeners(self.version)
                if ls is not None:
                    self.envoy_listeners = ls

                if (
                        self.envoy_listeners and (
                        not req.version_info or
                        not req.response_nonce or
                        (
                                req.version_info != str(self.version) and
                                req.response_nonce == self.nonce
                        )
                        )
                ):
                    self.nonce = str(uuid.uuid4())
                    resp = discovery_pb2.DiscoveryResponse(
                        version_info=str(self.version),
                        type_url=req.type_url,
                        nonce=self.nonce
                    )
                    for l in self.envoy_listeners:
                        res = resp.resources.add()
                        res.Pack(l)

                    yield resp
                    break

                time.sleep(1)


class ClusterDiscoveryServiceServicer(cds_grpc.ClusterDiscoveryServiceServicer):
    def __init__(self, cluster_state):
        self.version = 0
        self.nonce = None
        self.cluster_state = cluster_state
        self.envoy_clusters = None

    def FetchClusters(self, request, context):
        resp = discovery_pb2.DiscoveryResponse(
            version_info="12345",
            type_url=request.type_url,
            nonce=request.response_nonce,
        )
        res = resp.resources.add()
        res.Pack(self.c0)
        return resp

    def StreamClusters(self, request_iterator, context):
        for req in request_iterator:

            while True:
                self.version, cs = self.cluster_state.render_envoy_clusters(self.version)
                if cs is not None:
                    self.envoy_clusters = cs

                if (
                        self.envoy_clusters and (
                        not req.version_info or
                        not req.response_nonce or
                        (
                                req.version_info != str(self.version) and
                                req.response_nonce == self.nonce
                        )
                        )
                ):
                    self.nonce = str(uuid.uuid4())
                    resp = discovery_pb2.DiscoveryResponse(
                        version_info=str(self.version),
                        type_url=req.type_url,
                        nonce=self.nonce
                    )

                    for c in self.envoy_clusters:
                        res = resp.resources.add()
                        res.Pack(c)

                    yield resp
                    break

                time.sleep(1)
            time.sleep(1)


class EnvoyGRPC(object):
    def __init__(self, config, cs):
        self.cs = cs
        self.server = grpc.server(futures.ThreadPoolExecutor(max_workers=10))
        cds_grpc.add_ClusterDiscoveryServiceServicer_to_server(
            ClusterDiscoveryServiceServicer(cs),
            self.server
        )
        lds_grpc.add_ListenerDiscoveryServiceServicer_to_server(
            ListenerDiscoveryServiceServicer(cs),
            self.server
        )

        self.server.add_insecure_port('[::]:7255')
        self.server.start()
